% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raddv.R
\name{raddv}
\alias{raddv}
\title{Protocol Deviations Analysis Dataset (ADDV)}
\usage{
raddv(
  adsl,
  max_n_dv = 3L,
  p_dv = 0.15,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(ASTDT = c(seed = 1234, percentage = 0.1), DVCAT = c(seed = 1234,
    percentage = 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{max_n_dv}{(\code{integer})\cr Maximum number of deviations per patient. Defaults to 3.}

\item{p_dv}{(\code{proportion})\cr Probability of a patient having protocol deviations.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADDV data \code{caddv} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{raddv} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating random Protocol Deviations Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per each record in the corresponding SDTM domain.

Keys: \code{STUDYID}, \code{USUBJID}, \code{ASTDT}, \code{DVTERM}, \code{DVSEQ}
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)

addv <- raddv(adsl, seed = 2)
addv
}
