% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_scrap.R
\name{tidy_scrap}
\alias{tidy_scrap}
\title{Website Tidy scraping}
\usage{
tidy_scrap(link, nodes, colnames, clean = FALSE, askRobot = FALSE)
}
\arguments{
\item{link}{the link of the web page to scrape}

\item{nodes}{the vector of HTML or CSS elements to consider, the SelectorGadget tool is highly recommended.}

\item{colnames}{the names of the expected columns.}

\item{clean}{logical. Should the function clean the extracted tibble or not ? Default is FALSE.}

\item{askRobot}{logical. Should the function ask the robots.txt if we're allowed or not to scrape the web page ? Default is FALSE.}
}
\value{
a tidy data frame.
}
\description{
This function is used to scrape a tibble from a website.
}
\examples{
\donttest{
# Extracting imdb movie titles and rating

link     <- "https://www.imdb.com/chart/top/"
my_nodes <- c(".titleColumn a", "strong")
names    <- c("title", "rating")

tidy_scrap(link, my_nodes, names)}

}
