% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpc_read_rawdata.R
\name{cpc_read_rawdata}
\alias{cpc_read_rawdata}
\title{Read downloaded raw rainfall data from CPC}
\usage{
cpc_read_rawdata(
  yr,
  mo,
  day,
  raw_data_path = "",
  usa = FALSE,
  write_output = FALSE
)
}
\arguments{
\item{yr}{Year associated with the downloaded file, 1979/1948 - present}

\item{mo}{Month associated with the downloaded file, 1 - 12}

\item{day}{Day associated with the downloaded file, 1 - 28/29/30/31}

\item{raw_data_path}{location of downloaded cpc files}

\item{usa}{logical flag to indicate whether global or usa data is desired}

\item{write_output}{logical flag to indicate whether binary output file should
be written or not}
}
\value{
RasterLayer
}
\description{
Read downloaded raw rainfall data from CPC
}
\details{
For the global data - the output matrix has 360 rows (latitudes)
and 720 columns (longitudes) of rainfall/precipitation in units of mm/day;
the first data point has the lat, lon values of -89.75 and 0.25 degrees,
respectively; spatial resolution of the data is 0.5 degrees. For the USA
data - the output matrix has 120 rows (latitudes) and 300 columns
(longitudes) of rainfall/precipitation in units of mm/day; the first data
point has the lat, lon values of 20.125 and 230.125 degrees, respectively;
spatial resolution of the data is 0.25 degrees.
}
\examples{
\dontrun{
# CPC global data for July 4 2014
rain1 <- cpc_read_rawdata(2014, 7, 4)
print(rain1)
# CPC USA data for July 4 2014
rain2 <- cpc_read_rawdata(2014, 7, 4, usa = TRUE)
print(rain2)
}
}
\author{
Gopi Goteti
}
