% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/compare_means.R
\name{compare_means}
\alias{compare_means}
\title{Compare means for two or more variables}
\usage{
compare_means(dataset, cm_var1, cm_var2, data_filter = "",
  cm_paired = "independent", cm_alternative = "two.sided",
  cm_sig_level = 0.95, cm_adjust = "none")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{cm_var1}{A numeric variable or factor selected for comparison}

\item{cm_var2}{One or more numeric variables for comparison. If cm_var1 is a factor only one variable can be selected and the mean of this variable is compared across (factor) levels of cm_var1}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{cm_paired}{Are samples indepent ("independent") or not ("paired")}

\item{cm_alternative}{The alternative hypothesis ("two.sided", "greater" or "less")}

\item{cm_sig_level}{Span of the confidence interval}

\item{cm_adjust}{Adjustment for multiple comparisons ("none" or "bonf" for Bonferroni)}
}
\value{
A list of all variables defined in the function as an object of class compare_means
}
\description{
Compare means for two or more variables
}
\details{
See \url{http://vnijs.github.io/radiant/quant/compare_means.html} for an example in Radiant
}
\examples{
result <- compare_means("diamonds","cut","price")
}
\seealso{
\code{\link{summary.compare_means}} to summarize results

\code{\link{plot.compare_means}} to plot results
}

