% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prmap.R
\name{summary.prmap}
\alias{summary.prmap}
\title{Summary method for the prmap function}
\usage{
\method{summary}{prmap}(object, cutoff = 0, dec = 2, ...)
}
\arguments{
\item{object}{Return value from \code{\link{prmap}}}

\item{cutoff}{Show only loadings with (absolute) values above cutoff (default = 0)}

\item{dec}{Rounding to use for output}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the prmap function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/prmap.html} for an example in Radiant
}
\examples{
result <- prmap(computer, brand = "brand", attr = "high_end:business")
summary(result)
summary(result, cutoff = .3)
prmap(
  computer, brand = "brand", attr = "high_end:dated",
  pref = c("innovative","business")
) \%>\% summary()

}
\seealso{
\code{\link{prmap}} to calculate results

\code{\link{plot.prmap}} to plot results
}
