% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{plot.nn}
\alias{plot.nn}
\title{Plot method for the nn function}
\usage{
\method{plot}{nn}(x, plots = "garson", size = 12, nrobs = -1,
  shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{nn}}}

\item{plots}{Plots to produce for the specified Neural Network model. Use "" to avoid showing any plots (default). Options are "olden" or "garson" for importance plots, or "net" to depict the network structure}

\item{size}{Font size used}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the nn function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nn.html} for an example in Radiant
}
\examples{
result <- nn(titanic, "survived", c("pclass", "sex"), lev = "Yes")
plot(result, plots = "net")
plot(result, plots = "olden")

}
\seealso{
\code{\link{nn}} to generate results

\code{\link{summary.nn}} to summarize results

\code{\link{predict.nn}} for prediction
}
