% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\name{dtree}
\alias{dtree}
\title{Create a decision tree}
\usage{
dtree(yl, opt = "max", base = character(0))
}
\arguments{
\item{yl}{A yaml string or a list (e.g., from yaml::yaml.load_file())}

\item{opt}{Find the maximum ("max") or minimum ("min") value for each decision node}

\item{base}{List of variable definitions from a base tree used when calling a sub-tree}
}
\value{
A list with the initial tree and the calculated tree
}
\description{
Create a decision tree
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/dtree.html} for an example in Radiant
}
\examples{
yaml::as.yaml(movie_contract) \%>\% cat()
dtree(movie_contract, opt = "max") \%>\% summary(output = TRUE)

}
\seealso{
\code{\link{summary.dtree}} to summarize results

\code{\link{plot.dtree}} to plot results

\code{\link{sensitivity.dtree}} to plot results
}
