% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness.R
\name{plot.goodness}
\alias{plot.goodness}
\title{Plot method for the goodness function}
\usage{
\method{plot}{goodness}(x, check = "", shiny = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{goodness}}}

\item{check}{Show plots for variable var. "observed" for the observed frequencies table, "expected" for the expected frequencies table (i.e., frequencies that would be expected if the null hypothesis holds), "chi_sq" for the contribution to the overall chi-squared statistic for each cell (i.e., (o - e)^2 / e), and "dev_std" for the standardized differences between the observed and expected frequencies (i.e., (o - e) / sqrt(e))}

\item{shiny}{Did the function call originate inside a shiny app}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the goodness function
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/goodness} for an example in Radiant
}
\examples{
result <- goodness("newspaper", "Income")
plot(result, check = c("observed","expected","chi_sq"))
newspaper \%>\% goodness("Income") \%>\% plot(c("observed","expected"))

}
\seealso{
\code{\link{goodness}} to calculate results

\code{\link{summary.goodness}} to summarize results
}

