% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\title{Calculate correlations for two or more variables}
\usage{
correlation(dataset, vars, method = "pearson", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{vars}{Variables to include in the analysis}

\item{method}{Type of correlations to calculate. Options are "pearson", "spearman", and "kendall". "pearson" is the default}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list with all variables defined in the function as an object of class compare_means
}
\description{
Calculate correlations for two or more variables
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/correlation.html} for an example in Radiant
}
\examples{
result <- correlation("diamonds", c("price","carat"))
result <- correlation("diamonds", c("price","carat","table"))
result <- correlation("diamonds", "price:carat")
result <- diamonds \%>\% correlation("price:carat")

}
\seealso{
\code{\link{summary.correlation_}} to summarize results

\code{\link{plot.correlation_}} to plot results
}

