/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.python.core.ClassDictInit;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBeanEvent;
import org.python.core.PyBeanEventProperty;
import org.python.core.PyBeanProperty;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyIterator;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyReflectedField;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;
import org.python.core.util.StringUtil;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyJavaType
extends PyType {
    private static final Class<?>[] OO = new Class[]{PyObject.class, PyObject.class};
    private static Map<Class<?>, PyBuiltinMethod[]> collectionProxies;

    public static PyObject wrapJavaObject(Object o) {
        PyObjectDerived obj = new PyObjectDerived(PyType.fromClass(o.getClass()));
        obj.javaProxy = o;
        return obj;
    }

    public PyJavaType() {
        super(TYPE == null ? PyJavaType.fromClass(PyType.class) : TYPE);
    }

    @Override
    public Class<?> getProxyType() {
        return PyObject.class.isAssignableFrom(this.underlying_class) ? null : this.underlying_class;
    }

    @Override
    protected void checkDelattr() {
    }

    @Override
    protected void checkSetattr() {
    }

    @Override
    protected boolean useMetatypeFirst(PyObject attr) {
        return !(attr instanceof PyReflectedField) && !(attr instanceof PyReflectedFunction);
    }

    @Override
    PyObject[] compute_mro() {
        return this.mro;
    }

    @Override
    protected void init() {
        Constructor<?>[] constructors;
        Field[] fields;
        Method[] methods;
        this.name = this.underlying_class.getName();
        if (this.name.startsWith("org.python.core.Py")) {
            this.name = this.name.substring("org.python.core.Py".length()).toLowerCase();
        }
        this.dict = new PyStringMap();
        Class baseClass = this.underlying_class.getSuperclass();
        if (PyObject.class.isAssignableFrom(this.underlying_class)) {
            this.computeLinearMro(baseClass);
        } else {
            this.javaProxy = this.underlying_class;
            this.objtype = PyType.fromClass(Class.class);
            this.base = baseClass == null ? PyType.fromClass(PyObject.class) : (this.underlying_class == Class.class ? PyType.fromClass(PyType.class) : PyType.fromClass(baseClass));
            this.bases = new PyObject[1 + this.underlying_class.getInterfaces().length];
            this.bases[0] = this.base;
            for (int i = 1; i < this.bases.length; ++i) {
                this.bases[i] = PyType.fromClass(this.underlying_class.getInterfaces()[i - 1]);
            }
            Set seen = Generic.set();
            List<PyObject> mros = Generic.list();
            mros.add(this);
            for (PyObject obj : this.bases) {
                for (PyObject pyObject : ((PyType)obj).mro) {
                    if (!seen.add(pyObject)) continue;
                    mros.add(pyObject);
                }
            }
            this.mro = mros.toArray(new PyObject[mros.size()]);
        }
        if (!Modifier.isPublic(this.underlying_class.getModifiers()) && !this.name.startsWith("org.python.core") && Options.respectJavaAccessibility) {
            this.handleSuperMethodArgCollisions();
            return;
        }
        Map<String, PyBeanProperty> props = Generic.map();
        Map<String, PyBeanEvent<?>> events = Generic.map();
        if (Options.respectJavaAccessibility) {
            methods = this.underlying_class.getMethods();
        } else {
            for (Method method : methods = this.underlying_class.getDeclaredMethods()) {
                method.setAccessible(true);
            }
        }
        for (Method meth : methods) {
            if (!PyJavaType.declaredOnMember(baseClass, meth) || PyJavaType.ignore(meth)) continue;
            String methname = meth.getName();
            String nmethname = PyJavaType.normalize(methname);
            PyReflectedFunction pyReflectedFunction = (PyReflectedFunction)this.dict.__finditem__(nmethname);
            if (pyReflectedFunction == null) {
                this.dict.__setitem__(nmethname, (PyObject)new PyReflectedFunction(meth));
            } else {
                pyReflectedFunction.addMethod(meth);
            }
            if (Modifier.isStatic(meth.getModifiers())) continue;
            int n = meth.getParameterTypes().length;
            if ((methname.startsWith("add") || methname.startsWith("set")) && methname.endsWith("Listener") && n == 1 && meth.getReturnType() == Void.TYPE && EventListener.class.isAssignableFrom(meth.getParameterTypes()[0])) {
                Class<?> eventClass = meth.getParameterTypes()[0];
                String ename = eventClass.getName();
                int idot = ename.lastIndexOf(46);
                if (idot != -1) {
                    ename = ename.substring(idot + 1);
                }
                ename = PyJavaType.normalize(StringUtil.decapitalize(ename));
                events.put(ename, new PyBeanEvent(ename, eventClass, meth));
                continue;
            }
            String name = null;
            boolean get = true;
            if (methname.startsWith("get") && methname.length() > 3 && n == 0) {
                name = methname.substring(3);
            } else if (methname.startsWith("is") && methname.length() > 2 && n == 0 && meth.getReturnType() == Boolean.TYPE) {
                name = methname.substring(2);
            } else if (methname.startsWith("set") && methname.length() > 3 && n == 1) {
                name = methname.substring(3);
                get = false;
            }
            if (name == null) continue;
            PyBeanProperty prop = (PyBeanProperty)props.get(name = PyJavaType.normalize(StringUtil.decapitalize(name)));
            if (prop == null) {
                prop = new PyBeanProperty(name, null, null, null);
                props.put(name, prop);
            }
            if (get) {
                prop.getMethod = meth;
                prop.myType = meth.getReturnType();
                continue;
            }
            prop.setMethod = meth;
        }
        for (Method meth : methods) {
            String nmethname = PyJavaType.normalize(meth.getName());
            PyReflectedFunction reflfunc = (PyReflectedFunction)this.dict.__finditem__(nmethname);
            if (reflfunc != null) {
                reflfunc.addMethod(meth);
                continue;
            }
            if (!PyReflectedFunction.isPackagedProtected(meth.getDeclaringClass()) || this.lookup(nmethname) != null) continue;
            this.dict.__setitem__(nmethname, (PyObject)new PyReflectedFunction(meth));
        }
        if (Options.respectJavaAccessibility) {
            fields = this.underlying_class.getFields();
        } else {
            for (Field field : fields = this.underlying_class.getDeclaredFields()) {
                field.setAccessible(true);
            }
        }
        for (Field field : fields) {
            String string;
            PyObject memb;
            if (!PyJavaType.declaredOnMember(baseClass, field)) continue;
            String fldname = field.getName();
            if (Modifier.isStatic(field.getModifiers()) && fldname.startsWith("__doc__") && fldname.length() > 7 && field.getType() == PyString.class && (memb = this.dict.__finditem__(string = fldname.substring(7).intern())) != null && memb instanceof PyReflectedFunction) {
                PyString doc = null;
                try {
                    doc = (PyString)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw Py.JavaError(e);
                }
                ((PyReflectedFunction)memb).__doc__ = doc;
            }
            if (this.dict.__finditem__(PyJavaType.normalize(fldname)) != null) continue;
            this.dict.__setitem__(PyJavaType.normalize(fldname), (PyObject)new PyReflectedField(field));
        }
        for (PyBeanEvent ev : events.values()) {
            if (this.dict.__finditem__(ev.__name__) == null) {
                this.dict.__setitem__(ev.__name__, (PyObject)ev);
            }
            for (Method method : ev.eventClass.getMethods()) {
                String name = method.getName().intern();
                if (this.dict.__finditem__(name) != null) continue;
                this.dict.__setitem__(name, (PyObject)new PyBeanEventProperty(name, ev.eventClass, ev.addMethod, method));
            }
        }
        for (PyBeanProperty prop : props.values()) {
            PyObject prev = this.dict.__finditem__(prop.__name__);
            if (prev != null) {
                if (!(prev instanceof PyReflectedField) || !Modifier.isStatic(((PyReflectedField)prev).field.getModifiers())) continue;
                prop.field = ((PyReflectedField)prev).field;
            }
            if (prop.getMethod != null && prop.setMethod != null && prop.myType != prop.setMethod.getParameterTypes()[0]) {
                prop.setMethod = null;
            }
            this.dict.__setitem__(prop.__name__, (PyObject)prop);
        }
        final PyReflectedConstructor reflctr = new PyReflectedConstructor("_new_impl");
        if (Options.respectJavaAccessibility || Class.class == this.underlying_class) {
            constructors = this.underlying_class.getConstructors();
        } else {
            for (Constructor<?> constructor : constructors = this.underlying_class.getDeclaredConstructors()) {
                constructor.setAccessible(true);
            }
        }
        for (Constructor<?> constructor : constructors) {
            reflctr.addConstructor(constructor);
        }
        if (PyObject.class.isAssignableFrom(this.underlying_class)) {
            PyNewWrapper new_ = new PyNewWrapper(this.underlying_class, "__new__", -1, -1){

                public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                    return reflctr.make(args, keywords);
                }
            };
            this.dict.__setitem__("__new__", (PyObject)new_);
        } else {
            this.dict.__setitem__("__init__", (PyObject)reflctr);
        }
        for (GenericDeclaration genericDeclaration : this.underlying_class.getClasses()) {
            if (((Class)genericDeclaration).getDeclaringClass() != this.underlying_class || this.dict.__finditem__(((Class)genericDeclaration).getSimpleName()) != null) continue;
            if (((Class)genericDeclaration).getAnnotation(ExposedType.class) != null || ExposeAsSuperclass.class.isAssignableFrom((Class<?>)genericDeclaration)) {
                Py.BOOTSTRAP_TYPES.add((Class<?>)genericDeclaration);
            }
            this.dict.__setitem__(((Class)genericDeclaration).getSimpleName(), (PyObject)PyType.fromClass(genericDeclaration));
        }
        for (Map.Entry<Class<?>, PyBuiltinMethod[]> entry : PyJavaType.getCollectionProxies().entrySet()) {
            if (entry.getKey() != this.underlying_class) continue;
            for (PyBuiltinMethod meth : entry.getValue()) {
                this.dict.__setitem__(meth.info.getName(), (PyObject)new PyMethodDescr(this, meth));
            }
        }
        if (ClassDictInit.class.isAssignableFrom(this.underlying_class) && this.underlying_class != ClassDictInit.class) {
            try {
                Method m = this.underlying_class.getMethod("classDictInit", PyObject.class);
                m.invoke(null, this.dict);
                PyObject nameSpecified = this.dict.__finditem__("__name__");
                if (nameSpecified != null) {
                    this.name = nameSpecified.toString();
                }
            }
            catch (Exception exc) {
                throw Py.JavaError(exc);
            }
        }
        if (baseClass != Object.class) {
            this.has_set = PyJavaType.getDescrMethod(this.underlying_class, "__set__", OO) != null || PyJavaType.getDescrMethod(this.underlying_class, "_doset", OO) != null;
            this.has_delete = PyJavaType.getDescrMethod(this.underlying_class, "__delete__", PyObject.class) != null || PyJavaType.getDescrMethod(this.underlying_class, "_dodel", PyObject.class) != null;
        } else {
            PyBuiltinMethodNarrow equals = new PyBuiltinMethodNarrow("__eq__", 1, 1){

                public PyObject __call__(PyObject o) {
                    Object oAsJava;
                    Object proxy = this.self.getJavaProxy();
                    return proxy.equals(oAsJava = o.__tojava__(proxy.getClass())) ? Py.True : Py.False;
                }
            };
            this.dict.__setitem__("__eq__", (PyObject)new PyMethodDescr(this, equals));
            PyBuiltinMethodNarrow hash = new PyBuiltinMethodNarrow("__hash__", 0, 0){

                public PyObject __call__() {
                    return Py.newInteger(this.self.getJavaProxy().hashCode());
                }
            };
            this.dict.__setitem__("__hash__", (PyObject)new PyMethodDescr(this, hash));
            PyBuiltinMethodNarrow repr = new PyBuiltinMethodNarrow("__repr__", 0, 0){

                public PyObject __call__() {
                    return Py.newString(this.self.getJavaProxy().toString());
                }
            };
            this.dict.__setitem__("__repr__", (PyObject)new PyMethodDescr(this, repr));
        }
    }

    private void handleSuperMethodArgCollisions() {
        for (Class<?> iface : this.underlying_class.getInterfaces()) {
            for (Method meth : iface.getMethods()) {
                PyReflectedFunction func;
                PyObject[] where;
                String nmethname;
                PyObject obj;
                if (!Modifier.isPublic(meth.getDeclaringClass().getModifiers()) || (obj = this.lookup_where(nmethname = PyJavaType.normalize(meth.getName()), where = new PyObject[1])) == null) continue;
                if (where[0] == this) {
                    if (((PyReflectedFunction)obj).handles(meth)) continue;
                    ((PyReflectedFunction)obj).addMethod(meth);
                    continue;
                }
                if (obj instanceof PyReflectedFunction) {
                    func = ((PyReflectedFunction)obj).copy();
                    if (!func.handles(meth)) {
                        func.addMethod(meth);
                    }
                } else {
                    func = new PyReflectedFunction(meth);
                }
                this.dict.__setitem__(nmethname, (PyObject)func);
            }
        }
    }

    private static boolean declaredOnMember(Class<?> base, Member declaring) {
        return base == null || declaring.getDeclaringClass() != base && base.isAssignableFrom(declaring.getDeclaringClass());
    }

    private static String normalize(String name) {
        if (name.endsWith("$")) {
            name = name.substring(0, name.length() - 1);
        }
        return name.intern();
    }

    private static Method getDescrMethod(Class<?> c, String name, Class<?> ... parmtypes) {
        Method meth;
        try {
            meth = c.getMethod(name, parmtypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(meth.getModifiers()) && meth.getDeclaringClass() != PyObject.class) {
            return meth;
        }
        return null;
    }

    private static boolean ignore(Method meth) {
        Class<?>[] exceptions2;
        for (Class<?> exception : exceptions2 = meth.getExceptionTypes()) {
            if (exception != PyIgnoreMethodTag.class) continue;
            return true;
        }
        return false;
    }

    private static Map<Class<?>, PyBuiltinMethod[]> getCollectionProxies() {
        if (collectionProxies == null) {
            collectionProxies = Generic.map();
            PyBuiltinMethodNarrow iterableProxy = new PyBuiltinMethodNarrow("__iter__", 0, 0){

                public PyObject __call__() {
                    return new IteratorIter((Iterable)this.self.getJavaProxy());
                }
            };
            collectionProxies.put(Iterable.class, new PyBuiltinMethod[]{iterableProxy});
            PyBuiltinMethodNarrow lenProxy = new PyBuiltinMethodNarrow("__len__", 0, 0){

                public PyObject __call__() {
                    return Py.newInteger(((Collection)this.self.getJavaProxy()).size());
                }
            };
            PyBuiltinMethodNarrow containsProxy = new PyBuiltinMethodNarrow("__contains__", 1, 1){

                public PyObject __call__(PyObject obj) {
                    Object other = obj.__tojava__(Object.class);
                    boolean contained = ((Collection)this.self.getJavaProxy()).contains(other);
                    return contained ? Py.True : Py.False;
                }
            };
            collectionProxies.put(Collection.class, new PyBuiltinMethod[]{lenProxy, containsProxy});
            PyBuiltinMethodNarrow iteratorProxy = new PyBuiltinMethodNarrow("__iter__", 0, 0){

                public PyObject __call__() {
                    return new IteratorIter((Iterator)this.self.getJavaProxy());
                }
            };
            collectionProxies.put(Iterator.class, new PyBuiltinMethod[]{iteratorProxy});
            PyBuiltinMethodNarrow enumerationProxy = new PyBuiltinMethodNarrow("__iter__", 0, 0){

                public PyObject __call__() {
                    return new EnumerationIter((Enumeration)this.self.getJavaProxy());
                }
            };
            collectionProxies.put(Enumeration.class, new PyBuiltinMethod[]{enumerationProxy});
            MapMethod mapLenProxy = new MapMethod("__len__", 0, 0){

                public PyObject __call__() {
                    return Py.java2py(this.asMap().size());
                }
            };
            MapMethod mapIterProxy = new MapMethod("__iter__", 0, 0){

                public PyObject __call__() {
                    return new IteratorIter(this.asMap().keySet());
                }
            };
            MapMethod mapContainsProxy = new MapMethod("__contains__", 1, 1){

                public PyObject __call__(PyObject obj) {
                    Object other = obj.__tojava__(Object.class);
                    return this.asMap().containsKey(other) ? Py.True : Py.False;
                }
            };
            MapMethod mapGetProxy = new MapMethod("__getitem__", 1, 1){

                public PyObject __call__(PyObject key) {
                    return Py.java2py(this.asMap().get(Py.tojava(key, Object.class)));
                }
            };
            MapMethod mapPutProxy = new MapMethod("__setitem__", 2, 2){

                public PyObject __call__(PyObject key, PyObject value) {
                    return Py.java2py(this.asMap().put(Py.tojava(key, Object.class), Py.tojava(value, Object.class)));
                }
            };
            MapMethod mapRemoveProxy = new MapMethod("__delitem__", 1, 1){

                public PyObject __call__(PyObject key) {
                    return Py.java2py(this.asMap().remove(Py.tojava(key, Object.class)));
                }
            };
            collectionProxies.put(Map.class, new PyBuiltinMethod[]{mapLenProxy, mapIterProxy, mapContainsProxy, mapGetProxy, mapPutProxy, mapRemoveProxy});
            ListMethod listGetProxy = new ListMethod("__getitem__", 1, 1){

                public PyObject __call__(PyObject key) {
                    return new ListIndexDelegate(this.asList()).checkIdxAndGetItem(key);
                }
            };
            ListMethod listSetProxy = new ListMethod("__setitem__", 2, 2){

                public PyObject __call__(PyObject key, PyObject value) {
                    new ListIndexDelegate(this.asList()).checkIdxAndSetItem(key, value);
                    return Py.None;
                }
            };
            ListMethod listRemoveProxy = new ListMethod("__delitem__", 1, 1){

                public PyObject __call__(PyObject key) {
                    new ListIndexDelegate(this.asList()).checkIdxAndDelItem(key);
                    return Py.None;
                }
            };
            collectionProxies.put(List.class, new PyBuiltinMethod[]{listGetProxy, listSetProxy, listRemoveProxy});
        }
        return collectionProxies;
    }

    protected static class ListIndexDelegate
    extends SequenceIndexDelegate {
        private final List list;

        public ListIndexDelegate(List list) {
            this.list = list;
        }

        public void delItem(int idx) {
            this.list.remove(idx);
        }

        public PyObject getItem(int idx) {
            return Py.java2py(this.list.get(idx));
        }

        public PyObject getSlice(int start, int stop, int step) {
            List newList;
            if (step > 0 && stop < start) {
                stop = start;
            }
            int n = PySequence.sliceLength(start, stop, step);
            try {
                newList = (List)this.list.getClass().newInstance();
            }
            catch (Exception e) {
                throw Py.JavaError(e);
            }
            int j = 0;
            int i = start;
            while (j < n) {
                newList.add(this.list.get(i));
                i += step;
            }
            return Py.java2py(newList);
        }

        public String getTypeName() {
            return this.list.getClass().getName();
        }

        public int len() {
            return this.list.size();
        }

        public void setItem(int idx, PyObject value) {
            this.list.set(idx, value.__tojava__(Object.class));
        }

        public void setSlice(int start, int stop, int step, PyObject value) {
            if (stop < start) {
                stop = start;
            }
            if (step == 0) {
                return;
            }
            if (value.javaProxy == this) {
                ArrayList<PyObject> newseq = new ArrayList<PyObject>(this.len());
                for (PyObject object : (List)value.javaProxy) {
                    newseq.add(object);
                }
                value = Py.java2py(newseq);
            }
            int j = start;
            for (PyObject obj : value.asIterable()) {
                this.setItem(j, obj);
                j += step;
            }
        }

        public void delItems(int start, int stop) {
            int n = stop - start;
            while (n-- > 0) {
                this.delItem(start);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapMethod
    extends PyBuiltinMethodNarrow {
        protected MapMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Map<Object, Object> asMap() {
            return (Map)this.self.getJavaProxy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListMethod
    extends PyBuiltinMethodNarrow {
        protected ListMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected List<Object> asList() {
            return (List)this.self.getJavaProxy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorIter
    extends PyIterator {
        private Iterator<Object> proxy;

        public IteratorIter(Iterable<Object> proxy) {
            this(proxy.iterator());
        }

        public IteratorIter(Iterator<Object> proxy) {
            this.proxy = proxy;
        }

        @Override
        public PyObject __iternext__() {
            return this.proxy.hasNext() ? Py.java2py(this.proxy.next()) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationIter
    extends PyIterator {
        private Enumeration<Object> proxy;

        public EnumerationIter(Enumeration<Object> proxy) {
            this.proxy = proxy;
        }

        @Override
        public PyObject __iternext__() {
            return this.proxy.hasMoreElements() ? Py.java2py(this.proxy.nextElement()) : null;
        }
    }
}

