% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_basic.R
\name{get_basic}
\alias{get_basic}
\title{Get basic Strava data}
\usage{
get_basic(url_, stoken, queries = NULL)
}
\arguments{
\item{url_}{string of url for the request to the API}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{queries}{list of additional queries or parameters}
}
\value{
Data from an API request.
}
\description{
Get basic Strava data with requests that don't require pagination
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

# get basic user info
get_basic('https://www.strava.com/api/v3/athlete', stoken)
}
}
\concept{token}
