% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{deathFunction}
\alias{deathFunction}
\title{This allows SHAPE to simulate the death process as a deterministic value, and may be density dependent.}
\usage{
deathFunction(func_inSize, func_inProb = 0, func_roundValues = TRUE,
  func_depDensity = FALSE, func_densityMax = NULL,
  func_densityPower = 4)
}
\arguments{
\item{func_inSize}{This is the vector of population sizes within the community}

\item{func_inProb}{This is the general death probability defined for this run of SHAPE}

\item{func_roundValues}{This is a logical toggle to define if the number of births and deaths are
forced to be tracked as integer values.  If TRUE, then any fractional amounts will be stochastically
rounded to the nearest integer with a probability of being rounded up equal to the decimal value
-- ie: 0.32 means 32\% chance of being rounded up --}

\item{func_depDensity}{This is a logical toggle as to whether or not the calculation is density dependent.
If TRUE, then func_densityMax reuqires a value.}

\item{func_densityMax}{This is the community size at which maximum density dependent deaths
(ie: 100\% of func_inSize) occur.}

\item{func_densityPower}{This is a scaling factor that controls the rate of transition between
minimal and maximal values of the density dependent deaths.  Higher values mean a steeper transition
such that there are fewer deaths until higher densities are reached.}
}
\value{
A vector of the number of deaths caluclated for each of the populations represented by the func_inSize vector
}
\description{
This allows SHAPE to simulate the death process as a deterministic value, and may be density dependent.
}
\examples{
# Imagine you've got an evolving community of three populations where in each time step
# 100\% of individuals die.
deathFunction(func_inSize = c(100,50,200), func_inProb = 1)
# What if their deaths were scaled based on population density,
# or an environmental carrying capacity?
deathFunction(func_inSize = c(100,50,200), func_inProb = 1,
              func_depDensity = TRUE, func_densityMax = 400)
deathFunction(func_inSize = c(100,50,200), func_inProb = 1,
              func_depDensity = TRUE, func_densityMax = 500)
deathFunction(func_inSize = c(100,50,200), func_inProb = 1,
              func_depDensity = TRUE, func_densityMax = 350)

}
