% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-pref.r
\docType{methods}
\name{general_pref}
\alias{general_pref}
\alias{empty}
\alias{is.empty_pref}
\alias{length,preference-method}
\alias{length,basepref-method}
\alias{length,emptypref-method}
\alias{length,complexpref-method}
\alias{length,reversepref-method}
\alias{is.preference}
\alias{as.expression,preference-method}
\alias{as.expression,basepref-method}
\alias{as.expression,emptypref-method}
\alias{as.expression,complexpref-method}
\alias{as.expression,reversepref-method}
\alias{assoc.df}
\alias{assoc.df,preference-method}
\alias{assoc.df<-}
\alias{assoc.df<-,preference-method}
\title{Utility Functions for Preferences}
\usage{
empty()

is.empty_pref(x)

\S4method{length}{preference}(x)

is.preference(x)

\S4method{as.expression}{preference}(x, ...)

\S4method{assoc.df}{preference}(x)

\S4method{assoc.df}{preference}(x) <- value
}
\arguments{
\item{x}{A preference, or, for \code{is.preference}, an object to be tested if it is an (empty) preference.}

\item{...}{Optional arguments passed to \code{as.expression}.}

\item{value}{A data frame to associate with a preference object.}
}
\description{
Collection of some useful functions which are applicable to all preference objects.
}
\details{
The empty preference \code{empty()} is a neutral element for the complex preference compositions \code{{*, &, +}}. 
It holds that \code{empty() * p} and \code{empty() & p} is equal to \code{p} for all preferences \code{p}.

The function \code{length(p)} returns the term length of the preference term \code{p}
which is defined as the number of base preferences
in a complex preference term. The empty preference \code{empty()} has length 0, 
and all base preferences have length 1.

With \code{as.expression(p)} for a preference \code{p} the call to the preference is constructed. 
This means, \code{eval(as.expression(p))} returns the preference \code{p}, evaluated in the current environment.

The function \code{is.empty_pref} returns \code{TRUE} if \code{x} is the empty preference object 
\code{empty()} and \code{FALSE} otherwise.

With \code{assoc.df} the associated data frame of a preference can be retrieved or set.
Setting the associated data frame means that a partial evaluation based on this data frame is done. 
See \code{\link{show.pref}} for details on partial evaluation of preferences.
Next, the preference is linked to that data frame, such that \code{\link{peval}(p)} can be used instead of \code{psel(df, p)}.
It returns \code{NULL} if no data frame is associated.
Use \code{set.assoc.df(NULL)} to delete an associated data frame.
}
\examples{

# Same as low(a) * low(b).
p <- low(a) * low(b) * empty()

# Returns 2, as empty() does not count.
length(p)

# The preference expression (without empty()).
as.expression(p)

}
\seealso{
See \code{\link{base_pref}} for the construction of base preferences,
and \code{\link{complex_pref}} for the construction of complex preferences. 
See \code{\link{show.pref}} for string output and partial evaluation of preference terms.
}
