% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMouse-functions.R
\name{record}
\alias{record}
\title{Record mouse movements}
\usage{
record(n = 10, timeInterval = 5, failSafe = TRUE)
}
\arguments{
\item{n}{number of mouse moves to record. Default is \code{10}.}

\item{timeInterval}{(seconds). Record after how much seconds. Default is \code{5}.}

\item{failSafe}{Logical flag to allow for emergency stops. Default is \code{TRUE}.}
}
\value{
Prints "delay(2000); move(x,y); left()" to the console.
}
\description{
Record subsequent mouse movements and print to console.
}
\note{
If failSafe is \code{TRUE}, the function checks whether the mouse cursor is at the upper left position of the screen (pixel: x = 0, y = 0) . If so, the function fails and throws an error, allowing for emergency stops during code execution.

The record function calls the \code{coord()} function after the specified time interval passed and repeats \code{n} times. The console output can be pasted to a script to rapidly build a mouse macro. Unfortunately, this function is a work-around since it is not possible to record mouse events with the Java Robot Class. The console output is basically a template and can be adjusted to the needs of the user.
}
\examples{
\dontrun{
record()
}
}
\seealso{
\code{\link{coord}}, \code{\link{pos}}
}
\keyword{record,}
\keyword{recording}
