% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.richness.R
\name{msc.richness}
\alias{msc.richness}
\title{Minicircle Sequence Cluster richness}
\usage{
msc.richness(clustmatrices, samples, groups)
}
\arguments{
\item{clustmatrices}{a list of cluster matrices.}

\item{samples}{a vector containing the names of the samples. This can include all samples or it can be a subset.}

\item{groups}{a vector, of equal length as samples, specifying to which group (e.g. species) the samples belong to.}
}
\value{
\item{table}{a table containing the number of MSC per sample across different percent identities.}
\item{plot}{a boxplot visualizing previous results. }
}
\description{
The msc.richness function counts how many Minicircle Sequence Clusters (MSC) are present per sample across different percent identities.
}
\examples{
require(ggplot2)
data(matrices)
data(exData)

#### run function
richness <- msc.richness(matrices, samples = exData$samples, groups = exData$species)

apply(richness$table[which(richness$table$group=="L. peruviana"),-(1:2)], 2, mean)
apply(richness$table[which(richness$table$group=="L. braziliensis"),-(1:2)], 2, mean)
apply(richness$table[which(richness$table$group=="hybrid"),-(1:2)], 2, mean)  

#### visualize results
barplot(richness$table[,"id93"], names.arg = richness$table[,1],
        las=2, cex.names=0.4, main="N of MSC at id 93")

#### adjust plot
richness$plot + ggtitle("MSC richness across \% id") + 
                theme(axis.text.x = element_text(angle=45, hjust=1))

### show results of subset 
table(exData$species)
hybrid <- which(exData$species=="hybrid")
# richness.subset <- msc.richness(matrices, samples = exData$samples[hybrid], 
#                                 groups = exData$species[hybrid])

}
