% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rJavaEnv-package.R
\docType{package}
\name{rJavaEnv-package}
\alias{rJavaEnv}
\alias{rJavaEnv-package}
\title{rJavaEnv: 'Java' Environments for R Projects}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

The 'rJavaEnv' package addresses common issues with 'Java' environment management in 'R' for users of 'Java'/'rJava'-dependent 'R' packages such as 'r5r', 'opentripplanner', 'xlsx', 'openNLP', 'rWeka', 'RJDBC', 'tabulapdf', and many more. It resolves common problems like 'Java' not found, 'Java' version conflicts, missing 'Java' installations, and the inability to install 'Java' due to lack of administrative privileges. 'rJavaEnv' automates the download, installation, and setup of the 'Java Development Kit' ('JDK') on a per-project basis by setting the relevant 'JAVA_HOME' in the current 'R' session or the current working directory (via '.Rprofile', with the user's consent). Similar to what 'renv' does for 'R' packages, 'rJavaEnv' allows different 'Java' versions to be used across different projects, but can also be configured to allow multiple versions within the same project (e.g. with the help of 'targets' package). Note: there are a few extra steps for 'Linux' users, who don't have any 'Java' previously installed in their system, and who prefer package installation from source, rather then installing binaries from 'Posit Package Manager'. See documentation for details.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/e-kotov/rJavaEnv}
  \item \url{https://www.ekotov.pro/rJavaEnv/}
  \item Report bugs at \url{https://github.com/e-kotov/rJavaEnv/issues}
}

}
\author{
\strong{Maintainer}: Egor Kotov \email{kotov.egor@gmail.com} (\href{https://orcid.org/0000-0001-6690-5345}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Mauricio Vargas \email{mavargas11@uc.cl} (\href{https://orcid.org/0000-0003-1017-7574}{ORCID}) [contributor]
}

}
\keyword{internal}
