% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topNwords.R, R/jst_reversed.R, R/jst.R
\docType{methods}
\name{top20words}
\alias{top20words}
\alias{top20words,JST_reversed.result,numeric,numeric-method}
\alias{top20words,JST_reversed.result,ANY,ANY-method}
\alias{top20words,JST_reversed.result-method}
\alias{top20words,JST.result,numeric,numeric-method}
\alias{top20words,JST.result,ANY,ANY-method}
\alias{top20words,JST.result-method}
\title{Show top 20 words for topics/sentiments}
\usage{
top20words(x, topic = NULL, sentiment = NULL)

\S4method{top20words}{JST_reversed.result,numeric,numeric}(x, topic = NULL,
  sentiment = NULL)

\S4method{top20words}{JST_reversed.result,ANY,ANY}(x)

\S4method{top20words}{JST.result,numeric,numeric}(x, topic = NULL,
  sentiment = NULL)

\S4method{top20words}{JST.result,ANY,ANY}(x)
}
\arguments{
\item{x}{A results object from any of the models in the package}

\item{topic}{(optional) Integer. The topic to return words from.}

\item{sentiment}{(optional) Integer. The sentiment to return words from.}
}
\value{
If topic and sentiment are specified: A character vector containing
 the top 20 words for the requested topic-sentiment combination. Otherwise a
 data.frame containing the top 20 words for every topic-sentiment combination.
}
\description{
This method returns a vector containing the 20 words with the highest
estimated parameter values for any of the models estimated in this package.
If topic (and sentiment for the appropriate models) are not specified, the
top 20 words of every topic will be returned.This method calls the generic
\link{topNwords} method.
}
\examples{
model <- jst(quanteda::data_dfm_lbgexample, paradigm())
top20words(model, topic = 1, sentiment = 1)
}
