% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxycheck.R
\name{proxycheck}
\alias{proxycheck}
\title{Retrieve IP address metadata from ProxyCheck}
\usage{
proxycheck(ip, ..., api_key = proxycheck_api_key())
}
\arguments{
\item{ip}{an IP address (length 1 character vector)}

\item{...}{ProxyCheck API query flage (see Details)}

\item{api_key}{a ProxyCheck API key (see \code{\link[=proxycheck_api_key]{proxycheck_api_key()}})}
}
\description{
Pass in an IP address along with API key and any extra API query flags
and retrieve metadata about the IP from ProxyCheck.
}
\details{
You can specify values for any additional query flags via \code{...}.
The package will be updated as the \href{https://proxycheck.io/api/#query_flags}{supported flags}
change. Current supported query flags are:
\itemize{
\item \code{vpn}: (logical) VPN check on the IP Address and present the result to you.
\item \code{asn}: (logical) ASN check on the IP Address and present you with the provider name,
ASN, country, country isocode, city (if it's in a city) and lang/long for the IP Address.
\item \code{node}: (logical) Will return node within our cluster answered your API call.
This is only really needed for diagnosing problems with our support staff.
\item \code{time}: (logical) Will return how long this query took to be answered by our API
excluding network overhead.
\item \code{inf}: (logical) When \code{FALSE} the query will \emph{not} use the real-time inference engine.
In the absence of this flag or if it's set to \code{TRUE} we will run the query through
our real-time inference engine.
\item \code{risk}: (logical) When \code{TRUE}, will return the risk score for this IP Address ranging from 0 to 100.
Scores below 33 can be considered low risk while scores between 34 and 66 can
be considered high risk. Addresses with scores above 66 are considered very dangerous.
\item \code{port}: (logical) Will return the port number we saw this IP Address operating a proxy server on.
\item \code{seen}: (logical) Will return the most recent time we saw this IP Address operating as a proxy server.
\item \code{days}: (integer) Will restrict proxy results to between now and the amount of days specified.
For example if you supplied \code{days=2} we would only check our database for
Proxies that we saw within the past 48 hours. By default without this flag supplied we
search within the past 7 days.
\item \code{tag}: (string) The query result will be tagged with the message you supply.
}
}
\examples{
\dontrun{
proxycheck("24.63.157.68", asn = TRUE, risk = TRUE)
}
}
\references{
\url{https://proxycheck.io/api/#introduction}
}
\author{
Bob Rudis (bob@rud.is)
}
