% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_existing.R
\name{get_existing}
\alias{get_existing}
\title{Return all entries posted to a table in the data registry}
\usage{
get_existing(
  table,
  limit_results = TRUE,
  detail = "all",
  endpoint = "http://localhost:8000/api/"
)
}
\arguments{
\item{table}{a \code{string} specifying the name of the table}

\item{limit_results}{a \code{boolean} specifying whether or not to limit
the results, default is \code{TRUE}}

\item{detail}{a \code{string} specifying what level of detail to return;
options are \code{"all"} for all details or \code{"id"} for just URL and IDs}

\item{endpoint}{a \code{string} specifying the registry endpoint}
}
\value{
Returns a \code{data.frame} of entries in table, default is limited
to 100 entries
}
\description{
Get entries (from the data registry) in a particular table
}
\seealso{
Other get functions: 
\code{\link{get_components}()},
\code{\link{get_entry}()},
\code{\link{get_file_hash}()},
\code{\link{get_github_hash}()}
}
\concept{get functions}
