/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache.web;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.boot.autoconfigure.mustache.web.MustacheView;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class MustacheViewResolver
extends UrlBasedViewResolver {
    private Mustache.Compiler compiler = Mustache.compiler();
    private String charset;

    public MustacheViewResolver() {
        this.setViewClass(MustacheView.class);
    }

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        Resource resource = this.resolveResource(viewName, locale);
        if (resource == null) {
            return null;
        }
        MustacheView view = new MustacheView(this.createTemplate(resource));
        view.setApplicationContext(this.getApplicationContext());
        view.setServletContext(this.getServletContext());
        return view;
    }

    private Template createTemplate(Resource resource) throws IOException {
        return this.charset == null ? this.compiler.compile((Reader)new InputStreamReader(resource.getInputStream())) : this.compiler.compile((Reader)new InputStreamReader(resource.getInputStream(), this.charset));
    }

    private Resource resolveResource(String viewName, Locale locale) {
        return this.resolveFromLocale(viewName, this.getLocale(locale));
    }

    private String getLocale(Locale locale) {
        if (locale == null) {
            return "";
        }
        LocaleEditor localeEditor = new LocaleEditor();
        localeEditor.setValue((Object)locale);
        return "_" + localeEditor.getAsText();
    }

    private Resource resolveFromLocale(String viewName, String locale) {
        Resource resource = this.getApplicationContext().getResource(this.getPrefix() + viewName + locale + this.getSuffix());
        if (resource == null || !resource.exists()) {
            if (locale.isEmpty()) {
                return null;
            }
            int index = locale.lastIndexOf("_");
            return this.resolveFromLocale(viewName, locale.substring(0, index));
        }
        return resource;
    }
}

