/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

class OnResourceCondition
extends SpringBootCondition {
    private final ResourceLoader defaultResourceLoader = new DefaultResourceLoader();

    OnResourceCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnResource.class.getName(), true);
        if (attributes != null) {
            ResourceLoader loader = context.getResourceLoader() == null ? this.defaultResourceLoader : context.getResourceLoader();
            ArrayList<String> locations = new ArrayList<String>();
            this.collectValues(locations, (List)attributes.get((Object)"resources"));
            Assert.isTrue((locations.size() > 0 ? 1 : 0) != 0, (String)"@ConditionalOnResource annotations must specify at least one resource location");
            for (String location : locations) {
                if (loader.getResource(location).exists()) continue;
                return ConditionOutcome.noMatch("resource not found: " + location);
            }
        }
        return ConditionOutcome.match();
    }

    private void collectValues(List<String> names, List<Object> values) {
        for (Object value : values) {
            for (Object item : (Object[])value) {
                names.add((String)item);
            }
        }
    }
}

