% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonTest.R
\name{wilcoxonTest}
\alias{wilcoxonTest}
\alias{print.wilcoxonTestSPSS}
\title{Wilcoxon Signed Rank and Rank Sum Tests}
\usage{
wilcoxonTest(data, variables, group = NULL, exact = FALSE)

\method{print}{wilcoxonTestSPSS}(x, digits = 2:3, statistics = c("ranks", "test"), ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying numeric variable(s) to be
used.  If \code{group} is \code{NULL}, the Wilcoxon signed rank test is
performed and this should be a character vector specifying two numeric
variables which contain the paired observations.  If a grouping variable is
specified in \code{group}, the Wilcoxon rank sum test is performed and this
should be a character string specifying the numeric variable of interest.}

\item{group}{a character string specifying a grouping variable for the
Wilcoxon rank sum test, or \code{NULL}.}

\item{exact}{a logical indicating whether the Wilcoxon rank sum test
should also return the p-value of the exact test.  The default is
\code{FALSE}.  Note that the p-value of the asymptotic test is always
returned.}

\item{x}{an object of class \code{"wilcoxonTestSPSS"} as returned by
function \code{wilcoxonTest}.}

\item{digits}{an integer vector giving the number of digits after the comma
to be printed in the LaTeX tables.  The first element corresponds to the
number of digits in table with the summary of the ranks, and the second
element corresponds to the number of digits in the table for the test.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"ranks"} for a summary of the ranks
and \code{"test"} for test results.  The default is to print both tables.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"wilcoxonTestSPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing the relevant information
  on the ranks.}
  \item{\code{test}}{a list containing the results of the Wilcoxon signed
  rank test (only paired-sample test).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  relevant numeric variable(s).}
  \item{\code{n}}{an integer giving the number of observations (only
  paired-sample test).}
  \item{\code{w}}{numeric; the Wilcoxon rank sum test statistic (only
  independent-samples test).}
  \item{\code{asymptotic}}{a list containing the results of the Wilcoxon
  rank sum test using the normal approximation (only independent-samples
  test).}
  \item{\code{exact}}{a list containing the test statistic of the exact
  Wilcoxon rank sum test test, and if requested the corresponding p-value
  (only independent-samples test).}
  \item{\code{group}}{a character string containing the name of the
  grouping variable (only independent-samples test).}
  \item{\code{type}}{a character string giving the type of Wilcoxon test
  performed \code{"paired"} or \code{"independent"}).}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Perform a Wilcoxon signed rank test for a paired sample or a Wilcoxon rank
sum test for independent samples on variables of a data set.  The output
is printed as a LaTeX table that mimics the look of SPSS output (version
<24).
}
\note{
The Wilcoxon rank sum test also reports the value of the equivalent
Mann-Whitney U test statistic.
}
\examples{
## paired sample

# load data
data("Exams")

# test whether grades differ between the
# regular exam and the resit
wilcoxonTest(Exams, c("Regular", "Resit"))


## independent samples

# load data
data("Eredivisie")

# test whether market values differ between Dutch and foreign
# players
wilcoxonTest(Eredivisie, "MarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{htest}
