% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_nrow.R
\name{nrow_table}
\alias{nrow_table}
\title{Calculate Number of Lines Broken to for Each Table Row}
\usage{
nrow_table(tbl, size, page_size = size, padding = 0.2)
}
\arguments{
\item{tbl}{A data frame with attributes or a data frame's \code{rtf_footnote} or \code{rtf_source} attributes}

\item{size}{Table size in inches}

\item{page_size}{Page size in inches}

\item{padding}{Cell padding in inches}
}
\value{
a numeric vector of number of maximum lines broken to for each row
}
\description{
Calculate number of lines broken to for each row of a table
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame.
   \item Size is table's  width in inches.
   \item Page_size is page's width in inches.
   \item Return to a numeric vector of number of maximum lines broken to for each row.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr) # required for running example
tbl <- iris[c(1:4, 50:54), ] \%>\%
  rtf_title(title = "Iris example") \%>\%
  rtf_body()
r2rtf:::nrow_table(tbl, size = 2.55)
}
