% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_strwidth.R
\name{rtf_strwidth}
\alias{rtf_strwidth}
\title{Calculate String Width in Inches}
\usage{
rtf_strwidth(tbl)
}
\arguments{
\item{tbl}{A data frame}
}
\value{
an object with string width corresponding to each cell in the data frame \code{tbl}
}
\description{
Calculate string width in inches based on font (Times New Roman, Arial, etc.), font size, font style (bold, italic, bold-italic etc.), and text indent.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item \code{tbl} is a data frame.
   \item Return an object with string width corresponding to each cell in the data frame \code{tbl}.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr)
tbl <- data.frame(x = rep("This is a long sentence", 5),
                  y = "short")
tbl \%>\%
  rtf_body(text_font = c(1, 3)) \%>\%
  r2rtf:::rtf_strwidth()

}
