% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_paragraph.R
\name{rtf_paragraph}
\alias{rtf_paragraph}
\title{Paragraph to RTF Encode}
\usage{
rtf_paragraph(
  text,
  justification = "c",
  indent_first = 0,
  indent_left = 0,
  indent_right = 0,
  space = 1,
  space_before = 180,
  space_after = 180,
  new_page = FALSE,
  hyphenation = TRUE
)
}
\arguments{
\item{text}{rtf text obtained using \code{rtf_text()} function.}

\item{justification}{Justification for text.}

\item{indent_first}{First indent.}

\item{indent_left}{Left indent.}

\item{indent_right}{Right indent.}

\item{space}{Paragraph space.}

\item{space_before}{Line space before text.}

\item{space_after}{Line space after text.}

\item{new_page}{A boolean value to indicate whether to start a new page.}

\item{hyphenation}{A boolean value to indicate whether to use hyphenation.}
}
\description{
Paragraph to RTF Encode
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input paragraph justification is valid using \code{justification()}.
   \item Validate if input paragraph spacing is valid using \code{spacing()}.
   \item Validate if input indent and space arguments are numeric.
   \item Add left curly bracket followed by RTF syntax: two backward slashes followed by pard, to start of code.
   \item Add RTF syntax: two backward slashes followed by pagebb, if new_page argument is TRUE.
   \item Add RTF syntax: two backward slashes followed by sb, at start of line space_before argument.
   \item Add RTF syntax: two backward slashes followed by sa, at start of line space_after argument.
   \item Define paragraph space based on input argument for space and \code{spacing()}.
   \item Add RTF syntax: two backward slashes followed by fi, at start of line indent_first argument.
   \item Add RTF syntax: two backward slashes followed by li, at start of line indent_left argument.
   \item Add RTF syntax: two backward slashes followed by ri, at start of line indent_right argument.
   \item Define paragraph justification based on input argument for justification and \code{justification()}.
   \item Add RTF syntax: two backward slashes followed by hyphpar, if hyphenation argument is TRUE.
   \item Add RTF syntax: two backward slashes followed by hyphpar0, if hyphenation argument is FALSE.
   \item Add RTF syntax: two backward slashes followed by par, followed by right curly bracket to end of code.
   \item Combine all components into a single RTF code string.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

