% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_isos.R
\docType{data}
\name{region_isos}
\alias{region_isos}
\title{A dataset outlining various region definitions}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 7455 rows and 3 columns.
}
\usage{
region_isos
}
\description{
This dataset maps codes representing countries to regions.

For information about the ISO standard for country codes see
\url{https://www.iso.org/iso-3166-country-codes.html}.
}
\section{Definitions}{

\itemize{
\item \code{isos} (character): Countries in region, defined by iso code., * \code{region} (character): Benchmark region name., * \code{source} (character): Source publication from which the regions are defined.
}
}

\examples{
head(region_isos)
}
\seealso{
\link{data_dictionary}

Other iso codes: 
\code{\link{iso_codes}},
\code{\link{region_isos_demo}}
}
\concept{iso codes}
\keyword{datasets}
