% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_sda.R
\name{target_sda}
\alias{target_sda}
\title{Add targets for CO2 emissions per unit production at the portfolio level,
using the SDA approach}
\usage{
target_sda(
  data,
  ald,
  co2_intensity_scenario,
  use_credit_limit = FALSE,
  by_company = FALSE
)
}
\arguments{
\item{data}{A dataframe like the output of
\code{\link[r2dii.match:prioritize]{r2dii.match::prioritize()}}.}

\item{ald}{An asset-level data frame like \link[r2dii.data:ald_demo]{r2dii.data::ald_demo}.}

\item{co2_intensity_scenario}{A scenario data frame like
\link[r2dii.data:co2_intensity_scenario_demo]{r2dii.data::co2_intensity_scenario_demo}.}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to instead use the column
\code{loan_size_credit_limit}.}

\item{by_company}{Logical vector of length 1. \code{FALSE} defaults to outputting
\code{weighted_production_value} at the portfolio-level. Set to \code{TRUE} to output
\code{weighted_production_value} at the company-level.}
}
\value{
A tibble with the CO2 emissions factors attributed to
the portfolio. These values include the portfolio's actual projected CO2
emissions factors, the scenario pathway CO2 emissions factors and the SDA
calculated portfolio target emissions factors (see column
\code{emission_factor_metric}).
}
\description{
This function calculates targets of CO2 emissions per unit production at the
portfolio-level, otherwise referred to as "emissions factors". It uses the
\href{https://2degreesinvesting.github.io/r2dii.analysis/articles/sda-target.html}{sectoral-decarbonization approach (SDA)}
to calculate these targets.
}
\section{Handling grouped data}{

This function ignores existing groups and outputs ungrouped data.
}

\examples{
installed <- requireNamespace("r2dii.match", quietly = TRUE) &&
  requireNamespace("r2dii.data", quietly = TRUE)
if (!installed) stop("Please install r2dii.match and r2dii.data")

library(r2dii.match)
library(r2dii.data)

# Example datasets from r2dii.data
loanbook <- loanbook_demo
ald <- ald_demo
co2_scenario <- co2_intensity_scenario_demo

# WARNING: Remember to validate matches (see `?prioritize`)
matched <- prioritize(match_name(loanbook, ald))

# You may need to clean your data
anyNA(ald$emission_factor)
try(target_sda(matched, ald, co2_intensity_scenario = co2_scenario))

ald2 <- subset(ald, !is.na(emission_factor))
anyNA(ald2$emission_factor)

out <- target_sda(matched, ald2, co2_intensity_scenario = co2_scenario)

# The output includes the portfolio's actual projected emissions factors, the
# scenario pathway emissions factors, and the portfolio's target emissions
# factors.
out

# Split-view by metric
split(out, out$emission_factor_metric)

# Calculate company-level targets
out <- target_sda(
  matched, ald2,
  co2_intensity_scenario = co2_scenario,
  by_company = TRUE
)
}
\seealso{
Other functions to calculate scenario targets: 
\code{\link{target_market_share}()}
}
\concept{functions to calculate scenario targets}
