% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{save_d3_html}
\alias{save_d3_html}
\title{Save a D3 visualization as HTML}
\usage{
save_d3_html(
  d3,
  file,
  selfcontained = TRUE,
  libdir = NULL,
  background = "white",
  title = "D3 Visualization",
  knitrOptions = list()
)
}
\arguments{
\item{d3}{D3 visualization to save}

\item{file}{File to save HTML into}

\item{selfcontained}{Whether to save the HTML as a single self-contained file
(with external resources base64 encoded) or a file with external resources
placed in an adjacent directory.}

\item{libdir}{Directory to copy HTML dependencies into (defaults to
filename_files).}

\item{background}{Text string giving the html background color of the widget.
Defaults to white.}

\item{title}{Text to use as the title of the generated page.}

\item{knitrOptions}{A list of \pkg{knitr} chunk options.}
}
\description{
Save a D3 visualization to an HTML file (e.g. for sharing with others).
}
\details{
Using \code{selfcontained} set to \code{TRUE} requires \href{https://pandoc.org/}{pandoc}
to be installed.
}
\examples{
library(r2d3)

viz <- r2d3(
  data = c(0.3, 0.6, 0.8, 0.95, 0.40, 0.20),
  script = system.file("examples/barchart.js", package = "r2d3")
)

save_d3_html(
  viz,
  file = tempfile(fileext = ".html"),
  selfcontained = FALSE
)
}
\seealso{
\code{\link[=save_d3_png]{save_d3_png()}}
}
