% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmap.R
\name{qmap}
\alias{qmap}
\title{Build qmap object}
\usage{
qmap(..., extent = NULL, order = 1:length(mapdata),
  colors = 1:length(mapdata), fill = FALSE, prj = TRUE,
  basemap = c("none", "1m_aerial", "topo"), resolution = 300)
}
\arguments{
\item{...}{Spatial objects to map.  Maybe passed as objects, a list of 
spatial objects, or a \code{\link{qmap}} object}

\item{extent}{A \code{\link{sp}} or \code{\link[raster]{raster}} object to 
use as the initial extent of the map.  Defaults to the maximum
extent of all input object}

\item{order}{draw order of the spatial object. Defaults to order in mapdata}

\item{colors}{line colors. Defaults to 1:length(mapdata)}

\item{fill}{Logical to determine if polygons should be filled (using colors)
or just the border colored.}

\item{prj}{Logical to check projections of input spatial objects.
Transformation, if needed, should be done prior to mapping with 
\code{sp::spTransform()}.}

\item{basemap}{a basemap generated from \code{\link{get_basemap}}}

\item{resolution}{Specifies the width in pixels of the retrieved basemap.
Larger values result in higher resolution images but since
the images are downloaded for each zoom level can result
in delays.  Default is 300, while ~600 is a decent 
compromise for performance and image quality.}
}
\value{
Function displays a map from the input \code{mapdata} parameter and 
        returns a recorded plot.
}
\description{
This function builds the qmap object that forms the basis for the rest of 
the \code{\link{quickmapr}} package.
}
\examples{
\dontrun{
data(lake)
mymap<-list(elev,lake,buffer,length,samples)
qm<-qmap(mymap)
#change draw order and which data is displayed
qmap(qm,order=c(2,3,5))
#add a basemap
qm<-qmap(qm,basemap="1m_aerial", resolution = 800)
}
}
