% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/zo.R
\name{zo}
\alias{zo}
\title{Zooms out on current plot}
\usage{
zo(qmap_obj = NULL, zoom_perc = 0.5, loc = NULL)
}
\arguments{
\item{qmap_obj}{A qmap object.  Optional, but performs better with larger
data sets.}

\item{zoom_perc}{A proportion to determine the zoom level.  The x and y
axes are increased by this amount.  Default is 0.5.}

\item{loc}{A list with an x and y numeric indicating a location.  Default is
to interactively get loc value until escaped.}
}
\description{
Interactively zoom out on the current plot. Works on an existing
 \code{qmap} object.  Simply pass that object to \code{zo()}.  A single zoom
 out results and the extent of the \code{qmap} object is changed.
}
\examples{
\dontrun{
data(lake)
qm<-qmap(list(lake,buffer,elev))
zo(qm)
}
}

