% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_test.R
\name{repeat_test}
\alias{repeat_test}
\title{Repeatedly test properties of a function}
\usage{
repeat_test(property, tests = getOption("quickcheck.tests", 100L))
}
\arguments{
\item{property}{A function with no parameters which includes an expectation.}

\item{tests}{The number of tests to run.}
}
\value{
A \code{testthat} expectation object.
}
\description{
Repeatedly test properties of a function
}
\examples{
repeat_test(
  property = function() {
    num <- stats::runif(1, min = 0, max = 10)
    testthat::expect_true(num >= 0 && num <= 10)
  }
)
}
