% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_table.R
\name{display_table}
\alias{display_table}
\alias{display_table_group}
\title{Display a table used in paper}
\usage{
display_table(data = NULL, variables = NULL, group = NULL,
  mean_or_median = "mean", addNA = TRUE, table_margin = 2,
  discrete_limit = 10, exclude_discrete = TRUE, save_to_file = NULL,
  normtest = NULL, fill_variable = FALSE)

display_table_group(data = NULL, variables = NULL, group = NULL,
  super_group = NULL, group_combine = FALSE, mean_or_median = "mean",
  addNA = TRUE, table_margin = 2, discrete_limit = 10,
  exclude_discrete = TRUE, normtest = NULL, fill_variable = FALSE)
}
\arguments{
\item{data}{A data.frame}

\item{variables}{Column indices or names of the variables in the dataset to display, the default columns are all the variables except group variable}

\item{group}{Column indices or names of the first subgroup variables. Must provide.}

\item{mean_or_median}{A character to specify mean or median to used for continuous variables, either "mean" or "median". The default is "mean"}

\item{addNA}{Whether to include NA values in the table, see \code{\link{table}} for more details}

\item{table_margin}{Index of generate margin for, see \code{\link{prop.table}} for more details}

\item{discrete_limit}{Defining the minimal of unique value to display the variable as count and frequency, the default is 10}

\item{exclude_discrete}{Logical, whether to exclude discrete variables with more unique values specified by discrete_limit}

\item{save_to_file}{A character, containing file name or path}

\item{normtest}{A character indicating test of normality, the default method is \code{\link{shapiro.test}} when sample size no more than 5000, otherwise \code{\link[nortest]{lillie.test}} {Kolmogorov-Smirnov} is used, see package \strong{nortest} for more methods.Use 'shapiro.test', 'lillie.test', 'ad.test', etc to specify methods.}

\item{fill_variable}{A logical, whether to fill the variable column in result, the default is FALSE}

\item{super_group}{Column indices or names of the further subgroup variables.}

\item{group_combine}{A logical, subgroup analysis for combination of variables or for each variable. The default is FALSE (subgroup analysis for each variable)}
}
\description{
Display count, frequency or mean, standard deviation and test of normality, etc.
}
\section{Functions}{
\itemize{
\item \code{display_table_group}: Allow more subgroup analysis, see the package vignette for more details
}}

\note{
The return table is a data.frame.

- P.value1 is ANOVA P value for continuous variables and chi-square test P value for discrete variables

- P.value2 is Kruskal-Wallis test P value for continuous variables and fisher test P value for discrete variables if expected counts less than 5

- normality is normality test P value for each group
}
\examples{
\dontrun{
data(diabetes)
head(diabetes)
library(dplyr);library(rlang)
result_1<-diabetes \%>\%
 group_by(sex) \%>\%
 do(display_table(data=.,variables=c("age","smoking"),group="CFHrs2230199")) \%>\%
 ungroup()
result_2<-display_table_group(data=diabetes,variables=c("age","smoking"),
group="CFHrs2230199",super_group = "sex")
identical(result_1,result_2)
result_3<-display_table_group(data=diabetes,variables=c("age","education"),
group=c("smoking"),super_group = c("CFHrs2230199","sex"))
result_4<-display_table_group(data=diabetes,variables=c("age","education"),
group=c("smoking"),super_group = c("CFHrs2230199","sex"),group_combine=TRUE)
}
}
