% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eagles}
\alias{eagles}
\title{Golden Eagle Counts Data}
\format{
A data frame with 28 rows and 11 columns. Each row represents a spring observation period, and each column represents a variable:
\describe{
\item{Year}{observation year}
\item{Hours}{hours spent collecting observations}
\item{Eagles}{number of Golden Eagles observed}
\item{TotPrec}{total precipitation measured in mm}
\item{UniqueObservers}{number of principle observers who performed observations}
\item{PeterSherrington_Year}{indicator variable which is 1 for years in which Peter Sherrington was the most prevalent principle observer}
\item{observerPC1}{top 5 principal component scores calculated from the top twelve most prevalent principal observers}
\item{observerPC2}{top 5 principal component scores calculated from the top twelve most prevalent principal observers}
\item{observerPC3}{top 5 principal component scores calculated from the top twelve most prevalent principal observers}
\item{observerPC4}{top 5 principal component scores calculated from the top twelve most prevalent principal observers}
\item{observerPC5}{top 5 principal component scores calculated from the top twelve most prevalent principal observers}
}
}
\source{
RMERF (2020) EagleWatch.ca
}
\usage{
eagles
}
\description{
Golden Eagle counts for the years 1993 to 2020, collected by the Rocky Mountain Eagle Research Foundation (RMERF). Counts are made during the spring from April 1st until March 22nd each year. Data is available from Eaglewatch.ca.
}
\references{
Rocky Mountain Eagle Research Foundation (RMERF). EagleWatch.ca. (2020).
}
\keyword{datasets}
