% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_MPR.R
\name{calculate_MPR}
\alias{calculate_MPR}
\title{Calculate the Maxpoint Ratio}
\usage{
calculate_MPR(data, start_col = 3, data_is_norm = TRUE)
}
\arguments{
\item{data}{A dataframe containing the real-time fluorescence data.}

\item{start_col}{Integer, the column at which the background fluorescence should be read.}

\item{data_is_norm}{Logical, if the data has not been normalized, will make a call to normalize_RFU.}
}
\value{
A vector containing MPR values.
}
\description{
Maxpoint ratio is defined as the maximum relative fluorescence divided by the
background fluorescence.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
  "extdata/input_files",
  file = "test.xlsx",
  package = "quicR"
)
df_ <- quicR::get_real(file)[[1]]
print(calculate_MPR(df_))
}

}
