% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{freqtable}
\alias{freqtable}
\alias{freqtable.default}
\alias{freqtable.survey.design}
\title{Frequency table of variables}
\usage{
freqtable(.data, ...)

\method{freqtable}{default}(.data, ..., na.rm = FALSE, weights = NULL)

\method{freqtable}{survey.design}(.data, ..., na.rm = FALSE, weights = TRUE)
}
\arguments{
\item{.data}{a data frame or `survey.design` object}

\item{...}{one or more expressions accepted by \code{\link[dplyr]{select}}
selecting at least one variable}

\item{na.rm}{Whether to remove missing values in the variables.}

\item{weights}{If `.data` is a data frame, an optional expression
selecting a weighting variable.
If `.data` is a survey design, either `TRUE` (the default) to
to use survey weights, or `FALSE` or `NULL` to return unweighted
frequencies.}
}
\value{
The result is an array of class `table`.
}
\description{
Generate frequency tables for one or more variables in a data frame
or a survey design.
}
\examples{
data(hdv2003)
freqtable(hdv2003, nivetud, sport)
freqtable(hdv2003, nivetud, sport, sexe)
freqtable(hdv2003, nivetud, sport, weights=poids)
freqtable(hdv2003, starts_with("trav"))

# Using survey design objects
library(survey)
hdv2003_wtd <- svydesign(ids=~1, weights=~poids, data=hdv2003)
freqtable(hdv2003_wtd, nivetud, sport)

# Compute percentages based on frequencies
hdv2003 |> freqtable(sport) |> freq()
hdv2003 |> freqtable(sport, sexe) |> prop()
hdv2003 |> freqtable(sport, sexe) |> cprop()
}
\seealso{
\code{\link{freq}}, \code{\link{wtd.table}},
         \code{\link{xtabs}}, \code{\link{table}}.
}
