% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{freq}
\alias{freq}
\title{Generate frequency tables.}
\usage{
freq(
  x,
  digits = 1,
  cum = FALSE,
  total = FALSE,
  exclude = NULL,
  sort = "",
  valid = !(NA \%in\% exclude),
  levels = c("prefixed", "labels", "values"),
  na.last = TRUE
)
}
\arguments{
\item{x}{either a vector to be tabulated, or a table object}

\item{digits}{number of digits to keep for the percentages}

\item{cum}{if TRUE, display cumulative percentages}

\item{total}{if TRUE, add a final row with totals}

\item{exclude}{vector of values to exclude from the tabulation (if \code{x} is a vector)}

\item{sort}{if specified, allow to sort the table by increasing ("inc") or decreasing ("dec") frequencies}

\item{valid}{if TRUE, display valid percentages}

\item{levels}{the desired levels for the factor in case of labelled vector (\pkg{labelled} package
must be installed): "labels" for value labels, "values" for values or 
"prefixed" for labels prefixed with values}

\item{na.last}{if TRUE, NA values are always be last table row}
}
\value{
The result is an object of class data.frame.
}
\description{
Generate and format frequency tables from a variable or a table, with percentages and formatting options.
}
\examples{
# factor
data(hdv2003)
freq(hdv2003$qualif)
freq(hdv2003$qualif, cum = TRUE, total = TRUE)
freq(hdv2003$qualif, cum = TRUE, total = TRUE, sort ="dec")

# labelled data
data(fecondite)
freq(femmes$region)
freq(femmes$region, levels = "l")
freq(femmes$region, levels = "v")
}
\seealso{
\code{\link{table}}, \code{\link[questionr]{prop}}, \code{\link[questionr]{cprop}}, \code{\link[questionr]{rprop}}
}
