% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{wtd.mean}
\alias{wtd.mean}
\alias{wtd.var}
\title{Weighted mean and variance of a vector}
\usage{
wtd.mean(x, weights = NULL, na.rm = TRUE)
}
\arguments{
\item{x}{Numeric data vector}

\item{weights}{Numeric weights vector. Must be the same length as \code{x}}

\item{na.rm}{if \code{TRUE}, delete \code{NA} values.}
}
\description{
Compute the weighted mean or weighted variance of a vector. Exact copies of Hmisc 
functions.
}
\details{
If \code{weights} is \code{NULL}, then an uniform weighting is applied.
}
\examples{
data(hdv2003)
mean(hdv2003$age)
wtd.mean(hdv2003$age, weights=hdv2003$poids)
}
\seealso{
\code{\link{mean}},\code{\link{var}}, \code{\link{wtd.table}} and the \code{survey} package.
}
\author{
These functions are exact copies of the \code{wtd.mean} and \code{wtd.var}
function from the \link[Hmisc]{wtd.stats} package. They have been created by 
Frank Harrell, Department of Biostatistics, Vanderbilt University School of 
Medicine, <f.harrell@vanderbilt.edu>.
}
