% Generated by roxygen2 (4.0.2): do not edit by hand
\name{addNAstr}
\alias{addNAstr}
\title{Transform missing values of a factor to an extra level}
\source{
Adapted from James (\url{http://stackoverflow.com/a/5817181})
by Joseph Larmarange <joseph@larmarange.net>
}
\usage{
addNAstr(x, value = "NA", ...)
}
\arguments{
\item{x}{a vector of data, usually taking a small number of distinct values.}

\item{value}{string to use for the extra level name. If NULL, the extra level is created as NA, and the result is the same as the one of the \code{addNA} function.}

\item{...}{arguments passed to \code{addNA}.}
}
\value{
an object of class \code{"factor"}, original missing values being coded as an
extra level named \code{NA} if \code{as.string=FALSE}, \code{"NA"} if
\code{as.string=TRUE}, as specified by \code{as.string} if \code{as.string} is
a string.
}
\description{
This function modifies a factor by turning \code{NA} into an extra level
(so that \code{NA} values are counted in tables, for instance).
This version of \code{addNA} extends the same function provided in \R by
allowing to specify a string name for the extra level (see examples).
}
\examples{
f <- as.factor(c("a","b",NA,"a","b"))
f
addNAstr(f)
addNAstr(f, value="missing")
addNAstr(f, value=NULL)
}
\seealso{
\code{\link[base]{addNA}} (base).
}

