% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{agg}
\alias{agg}
\title{Aggregate an Atomic Vector by Group}
\usage{
agg(x, grp, rep = TRUE, rtn.grp = !rep, sep = "_", fun, ...)
}
\arguments{
\item{x}{atomic vector.}

\item{grp}{atomic vector or list of atomic vectors (e.g., data.frame)
specifying the groups. The atomic vector(s) must be the length of \code{x}
or else an error is returned.}

\item{rep}{logical vector of length 1 specifying whether the result of
\code{fun} should be repeated for every instance of the group in \code{x}
(TRUE) or only once for each group (FALSE).}

\item{rtn.grp}{logical vector of length 1 specifying whether the groups
(i.e., \code{grp}) should be included in the return object as columns. The
default is the opposite of \code{rep} as traditionally it is most important
to return the group columns when \code{rep} = FALSE.}

\item{sep}{character vector of length 1 specifying what string should
separate different group values when naming the return object. This
argument is only used if \code{grp} is a list of atomic vectors (e.g.,
data.frame) AND \code{rep} = FALSE AND \code{rtn.grp} = FALSE.}

\item{fun}{function to use for aggregation. This function is expected to
return an atomic vector of length 1.}

\item{...}{additional named arguments to \code{fun}.}
}
\value{
\describe{result of \code{fun} applied to \code{x} for each group
  within \code{grp}. The structure of the return object depends on the
  arguments \code{rep} and \code{rtn.grp}.

  \item{If \code{rep} = TRUE and \code{rtn.grp} = TRUE:}{then the return
  object is a data.frame with nrow = \code{nrow(data)} where the first
  columns are \code{grp} and the last column is the result of \code{fun}. If
  \code{grp} is not a list with names, then its colnames will be "Group.1",
  "Group.2", "Group.3" etc. similar to \code{aggregate}'s return object. The
  colname for the result of \code{fun} will be "x".}

  \item{If \code{rep} = TRUE and \code{rtn.grp} = FALSE:}{then the return
  object is an atomic vector with length = \code{length(x)} where the values
  are the result of \code{fun} and the names = \code{names(x)}.}

  \item{If \code{rep} = FALSE and \code{rtn.grp} = TRUE:}{then the return
  object is a data.frame with nrow = \code{length(levels(interaction(grp)))}
  where the first columns are the unique group combinations in \code{grp} and
  the last column is the result of \code{fun}. If \code{grp} is not a list
  with names, then its colnames will be "Group.1", "Group.2", "Group.3" etc.
  similar to \code{aggregate}'s return object. The colname for the result of
  \code{fun} will be "x".}

  \item{If \code{rep} = FALSE and code{rtn.grp} = FALSE:}{then the return
  object is an atomic vector with length
  \code{length(levels(interaction(grp)))} where the values are the result of
  \code{fun} and the names are each group value pasted together by \code{sep}
  if there are multiple grouping variables within \code{grp} (i.e.,
  \code{is.list(grp) && length(grp) > 2}).}
}
}
\description{
\code{agg} evaluates a function separately for each group and combines the
results back together into an atomic vector of data.frame that is returned.
Depending on the argument \code{rep}, the results of \code{fun} are repeated
for each element of \code{x} in the group (TRUE) or only once for each group
(FALSE). Depending on the argument \code{rtn.grp}, the return object is a
data.frame and the groups within \code{grp} are included in the data.frame as
columns (TRUE) or the return object is an atomic vector and the groups are
the names (FALSE).
}
\details{
If \code{rep} = TRUE, then \code{agg} calls \code{ave}; if \code{rep} =
FALSE, then \code{agg} calls \code{aggregate}.
}
\examples{

# one grouping variable
agg(x = airquality$"Solar.R", grp = airquality$"Month", fun = mean)
agg(x = airquality$"Solar.R", grp = airquality$"Month", fun = mean,
   na.rm = TRUE) # ignoring missing values
agg(x = setNames(airquality$"Solar.R", nm = row.names(airquality)), grp = airquality$"Month",
   fun = mean, na.rm = TRUE) # keeps the names in the return object
agg(x = airquality$"Solar.R", grp = airquality$"Month", rep = FALSE,
   fun = mean, na.rm = TRUE) # do NOT repeat aggregated values
agg(x = airquality$"Solar.R", grp = airquality$"Month", rep = FALSE, rtn.grp = FALSE,
   fun = mean, na.rm = TRUE) # groups are the names of the returned atomic vector

# two grouping variables
tmp_nm <- c("vs","am") # Roxygen2 doesn't like a c() within a []
agg(x = mtcars$"mpg", grp = mtcars[tmp_nm], rep = TRUE, fun = sd)
agg(x = mtcars$"mpg", grp = mtcars[tmp_nm], rep = FALSE,
   fun = sd) # do NOT repeat aggregated values
agg(x = mtcars$"mpg", grp = mtcars[tmp_nm], rep = FALSE, rtn.grp = FALSE,
   fun = sd) # groups are the names of the returned atomic vector
agg(x = mtcars$"mpg", grp = mtcars[tmp_nm], rep = FALSE, rtn.grp = FALSE,
   sep = ".", fun = sd) # change the separater for naming

# error messages
\dontrun{
   agg(x = airquality$"Solar.R", grp = mtcars[tmp_nm]) # error returned
   # b/c  atomic vectors within \code{grp} not having the same length as \code{x}
}

}
\seealso{
\code{aggs}
   \code{agg_dfm}
   \code{\link[stats]{ave}}
   \code{\link[stats]{aggregate}}
}
