% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{Extract.quantities}
\alias{Extract.quantities}
\alias{[.quantities}
\alias{[[.quantities}
\alias{[<-.quantities}
\alias{[[<-.quantities}
\title{Extract or Replace Parts of an Object}
\usage{
\method{[}{quantities}(x, ...)

\method{[[}{quantities}(x, ...)

\method{[}{quantities}(x, ...) <- value

\method{[[}{quantities}(x, ...) <- value
}
\arguments{
\item{x}{
    object from which to extract element(s) or in which to replace element(s).
  }

\item{...}{additional arguments to be passed to base methods
(see \code{\link[base]{Extract}}).}

\item{value}{typically an array-like \R object of a similar class as
    \code{x}.}
}
\description{
S3 operators to extract or replace parts of \code{quantities} objects.
}
\examples{
x <- set_quantities(1:3, m/s, 0.1)
y <- set_quantities(4:6, m/s, 0.2)
(z <- rbind(x, y))
z[2, 2]
z[2, 2] <- -1
errors(z[[1, 2]]) <- 0.8
z[, 2]

}
