% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-print.R, R/fcm.R
\docType{methods}
\name{print.dfm}
\alias{print.dfm}
\alias{print,dfm-method}
\alias{show,dfm-method}
\alias{print,fcm-method}
\alias{show,fcm-method}
\title{print a dfm object}
\usage{
\S4method{print}{dfm}(x, show.values = FALSE, show.settings = FALSE,
  show.summary = TRUE, ndoc = getOption("quanteda_print_dfm_max_ndoc"),
  nfeature = getOption("quanteda_print_dfm_max_nfeature"), ...)

\S4method{show}{dfm}(object)

\S4method{print}{fcm}(x, show.values = FALSE, show.settings = FALSE,
  show.summary = TRUE, nfeature = 20L, ...)

\S4method{show}{fcm}(object)
}
\arguments{
\item{x}{the dfm to be printed}

\item{show.values}{print the dfm values; if called explicitly this will print
all values, overriding \code{ndoc} and \code{nfeature}.}

\item{show.settings}{print the settings used to create the dfm.  See 
\link{settings}.}

\item{show.summary}{print a brief summary indicating the number of documents
and features}

\item{ndoc}{max number of documents to print; default is from the \code{quanteda_print_dfm_max_ndoc} setting}

\item{nfeature}{max number of features to print; ; default is from the \code{quanteda_print_dfm_max_nfeature} setting}

\item{...}{further arguments passed to or from other methods}

\item{object}{the item to be printed}
}
\description{
print methods for document-feature matrices
}
\seealso{
\code{\link{quanteda_options}}
}
\keyword{dfm}
\keyword{internal}
