% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tokenize.R
\name{tokenizeOnly}
\alias{tokenizeOnly}
\alias{tokenizeOnlyCppKB}
\alias{tokenizeOnlyScan}
\title{tokenizeOnly}
\usage{
tokenizeOnlyCppKB(x, sep = " ", minLength = 1)

tokenizeOnlyScan(x, sep = " ")
}
\arguments{
\item{x}{text(s) to be tokenized}

\item{sep}{separator delineating tokens}

\item{minLength}{minimum length in characters of tokens to be retained}
}
\value{
a list of character vectors, with each list element consisting of a
  tokenized text
}
\description{
For performance comparisons of tokenize-only functions. All
  functions use \code{\link{lapply}} to return a list of tokenized texts,
  when \code{x} is a vector of texts.
}
\details{
\code{tokenizeOnlyCppKB} calls a C++ function that KB adapted from
  Kohei's code that does tokenization without the cleaning.

\code{tokenizeOnlyScan} calls the R funtion \code{\link{scan}} for
  tokenization.
}
\examples{
# on inaugural speeches
# system.time(tmp1 <- tokenizeOnlyCppKW(inaugTexts))
system.time(tmp2 <- tokenizeOnlyCppKB(inaugTexts))
system.time(tmp3 <- tokenizeOnlyScan(inaugTexts))

\donttest{# on a longer set of texts
load('~/Dropbox/QUANTESS/Manuscripts/Collocations/Corpora/lauderdaleClark/Opinion_files.RData')
txts <- unlist(Opinion_files[1])
names(txts) <- NULL
# system.time(tmp4 <- tokenizeOnlyCppKW(txts))
## about  9.2 seconds on Ken's MacBook Pro
system.time(tmp5 <- tokenizeOnlyCppKB(txts))
## about  7.0 seconds
system.time(tmp6 <- tokenizeOnlyScan(txts))
## about 12.6 seconds
}
}

