% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dictionaryFunctions.R
\docType{class}
\name{dictionary-class}
\alias{dictionary}
\alias{dictionary-class}
\title{create a dictionary}
\usage{
dictionary(x = NULL, file = NULL, format = NULL, enc = "",
  tolower = TRUE, maxcats = 10)
}
\arguments{
\item{x}{a list of character vector dictionary entries, including regular
expressions (see examples)}

\item{file}{file identifier for a foreign dictionary}

\item{format}{character identifier for the format of the foreign dictionary.
Available options are: \describe{ \item{\code{"wordstat"}}{format used by Provalis
Research's Wordstat software} \item{\code{"LIWC"}}{format used by the Linguistic
Inquiry and Word Count software} }}

\item{enc}{optional encoding value for dictionaries imported in Wordstat
format}

\item{tolower}{if \code{TRUE}, convert all dictionary functions to lower}

\item{maxcats}{optional maximum categories to which a word could belong in a
LIWC dictionary file, defaults to 10 (which is more than the actual LIWC
2007 dictionary uses).  The default value of 10 is likely to be more than
enough.}
}
\value{
A list with a ductionary class label, to be used by other functions in quanteda.
}
\description{
Create a quanteda dictionary, either from a list or by importing from a
foreign format.  Currently supported formats are the Wordstat and LIWC
formats.
}
\note{
We will eventually change this to an S4 class with validators and additional methods.
}
\examples{
mycorpus <- subset(inaugCorpus, Year>1900)
mydict <-
    dictionary(list(christmas=c("Christmas", "Santa", "holiday"),
                    opposition=c("Opposition", "reject", "notincorpus"),
                    taxing="taxing",
                    taxation="taxation",
                    taxregex="tax*",
                    country="united states"))
dfm(mycorpus, dictionary=mydict)
\dontrun{
# import the Laver-Garry dictionary from http://bit.ly/1FH2nvf
lgdict <- dictionary(file="~/Dropbox/QUANTESS/dictionaries/Misc Provalis/LaverGarry.cat",
                     format="wordstat")
dfm(inaugTexts, dictionary=lgdict)

# import a LIWC formatted dictionary
liwcdict <- dictionary(file = "~/Dropbox/QUANTESS/dictionaries/LIWC/LIWC2001_English.dic",
                       format = "LIWC")
dfm(inaugTexts, dictionary=liwcdict)
}
}
\references{
Wordstat dictionaries page, from Provalis Research
  \url{http://provalisresearch.com/products/content-analysis-software/wordstat-dictionary/}.

  Pennebaker, J.W., Chung, C.K., Ireland, M., Gonzales, A., & Booth, R.J.
  (2007). The development and psychometric properties of LIWC2007. [Software
  manual]. Austin, TX (\url{www.liwc.net}).
}
\seealso{
\link{dfm}
}

