% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_svmlin.R
\name{textmodel_svmlin}
\alias{textmodel_svmlin}
\title{(faster) Linear SVM classifier for texts}
\usage{
textmodel_svmlin(x, y, intercept = TRUE, ...)
}
\arguments{
\item{x}{the \link{dfm} on which the model will be fit.  Does not need to
contain only the training documents.}

\item{y}{vector of training labels associated with each document identified
in \code{train}.  (These will be converted to factors if not already
factors.)}

\item{intercept}{logical; if \code{TRUE}, add an intercept to the data}

\item{...}{additional arguments passed to \code{\link[RSSL]{svmlin}}}
}
\value{
\code{textmodel_svmlin()} returns (for now) an object structured as a return
object from \code{\link[RSSL]{svmlin}}.
}
\description{
This function has been retained for testing purposes only;
we recommend that you use \code{\link{textmodel_svm}} instead.  That
function is more efficient, and implements prediction for more than
two classes.
}
\details{
Fit a fast linear SVM classifier for texts, using the R interface to the
svmlin code by Vikas Sindhwani and S. Sathiya Keerthi for fast linear
transductive SVMs. This is passed through to \code{\link[RSSL]{svmlin}} as
implemented by the \pkg{RSSL} package.
}
\examples{
# use Lenihan for govt class and Bruton for opposition
quanteda::docvars(data_corpus_irishbudget2010, "govtopp") <-
    c("Govt", "Opp", rep(NA, 12))
dfmat <- quanteda::dfm(data_corpus_irishbudget2010)

tmod <- textmodel_svmlin(dfmat, y = quanteda::docvars(dfmat, "govtopp"),
                         pos_frac = 5/14)
predict(tmod)

predict(textmodel_svmlin(dfmat, y = quanteda::docvars(dfmat, "govtopp"),
                         intercept = FALSE, pos_frac = 5/14))
}
\references{
Vikas Sindhwani and S. Sathiya Keerthi (2006).  Large Scale Semi-supervised
Linear SVMs. \emph{Proceedings of ACM SIGIR}.

V. Sindhwani and S. Sathiya Keerthi (2006).  Newton Methods for Fast Solution of Semi-supervised
Linear SVMs. Book Chapter in \emph{Large Scale Kernel Machines}, MIT Press, 2006.
}
\seealso{
\code{\link[RSSL]{svmlin}}, \code{text{textmodel_svm}}
}
\keyword{textmodel}
