% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{maps4x}
\alias{maps4x}
\title{Autotetraploid potato map}
\format{
An object of class \code{"mappoly.map"} from the package \pkg{mappoly}, which is a list of 12 linkage groups (LGs)
}
\usage{
maps4x
}
\description{
A real autotetraploid potato map containing 12 homology groups from a tetraploid potato full-sib family (Atlantic x B1829-5).
}
\examples{
library(mappoly)
plot_map_list(maps4x)
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2019) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.

    Mollinari M, Garcia AAF (2019) Linkage analysis and haplotype phasing in experimental autopolyploid populations with high ploidy level using hidden Markov models, \emph{G3: Genes|Genomes|Genetics} 9 (10): 3297-3314. \doi{10.1534/g3.119.400378}

    Pereira GS, Mollinari M, Schumann MJ, Clough ME, Zeng ZB, Yencho C (2021) The recombination landscape and multiple QTL mapping in a \emph{Solanum tuberosum} cv. ‘Atlantic’-derived F_1 population. Heredity. \doi{10.1038/s41437-021-00416-x}.
}
\seealso{
\code{\link[mappoly]{hexafake}}, \code{\link[qtlpoly]{pheno6x}}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
\keyword{datasets}
