% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fread_csv_numer.R
\name{fread_csv_numer}
\alias{fread_csv_numer}
\title{Read a csv file that has numeric columns}
\usage{
fread_csv_numer(
  filename,
  sep = ",",
  na.strings = c("NA", "-"),
  comment.char = "#",
  transpose = FALSE,
  rownames_included = TRUE
)
}
\arguments{
\item{filename}{Name of input file}

\item{sep}{Field separator}

\item{na.strings}{Missing value codes}

\item{comment.char}{Comment character; rest of line after this character is ignored}

\item{transpose}{If TRUE, transpose the result}

\item{rownames_included}{If TRUE, the first column is taken to be row names.}
}
\value{
Data frame
}
\description{
Read a csv file via \code{\link[data.table:fread]{data.table::fread()}} using a
particular set of options, including the ability to transpose the
result. This version assumes that the contents other than the first
column and the header row are strictly numeric.
}
\details{
Initial two lines can contain comments with number of rows
and columns. Number of columns includes an ID column; number of
rows does not include the header row.

The first column is taken to be a set of row names
}
\examples{
\dontrun{mydata <- fread_csv_numer("myfile.csv", transpose=TRUE)}
}
\seealso{
\code{\link[=fread_csv]{fread_csv()}}
}
