% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{cp_remote}
\alias{cp_remote}
\title{A wrapper around the scp shell command that handles local/remote files and allows
copying between remote hosts via the local machine.}
\usage{
cp_remote(remote_src, path_src, remote_dest, path_dest, verbose = FALSE,
  recursively = FALSE)
}
\arguments{
\item{remote_src}{Remote machine for the source file in the format \code{user@machine} or an empty string for local.}

\item{path_src}{Path of the source file.}

\item{remote_dest}{Remote machine for the destination file in the format \code{user@machine} or an empty string for local.}

\item{path_dest}{Path for the source file; can be a directory.}

\item{verbose}{Prints elapsed time if TRUE}

\item{recursively}{Copy a directory recursively?}
}
\description{
A wrapper around the scp shell command that handles local/remote files and allows
copying between remote hosts via the local machine.
}
\examples{
\dontrun{
## Copy file myfile.csv from the home directory on the remote server to
## the local working directory.

## on remote server in bash shell:
# cat myfile.csv
# [me@myserver ~]$ cat myfile.csv
# "val","ts"
# 1,
# 2,
# 3,
# 4,
# 5,
# 6,
# 7,
# 8,
# 9,
# 10,

## on local server in R:
cp_remote(remote_src = "me@myserver", path_src = "~/myfile.csv",
          remote_dest = FALSE, path_dest = getwd(), verbose = TRUE)
# [1] "Elapsed: 1.672 sec"
df <- read.csv("myfile.csv")
df
#    val ts
# 1    1 NA
# 2    2 NA
# 3    3 NA
# 4    4 NA
# 5    5 NA
# 6    6 NA
# 7    7 NA
# 8    8 NA
# 9    9 NA
# 10  10 NA
}
}
