% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cards.R
\name{print_cards}
\alias{print_cards}
\title{print_cards}
\usage{
print_cards(qset, desc_col = "description", dir.print)
}
\arguments{
\item{qset}{A data frame containing the Q-set items' descriptions.
For details see for example ?qset_aqs, ?qset_cqq, ?qset_mbqs and ?qset_pq.}

\item{desc_col}{Column name of qsets data frame containing items'
descriptions.}

\item{dir.print}{Directory path where .pdf file will be saved}
}
\value{
a pdf document with item’s descriptions displayed on separate cards.
}
\description{
print_cards creates a pdf document in a specified directory, with item’s
descriptions displayed on separate cards.
}
\examples{
\donttest{print_cards(qset_aqs, desc_col = "description", dir.print = tempdir())}

}
\references{
Baumrind, D. (1968). Manual for the Preschool Behaviour Q-set.
 Parental Research Project. Berkeley, CA: Institute of Human Development,
 University of California.

 Block, J. H., & Block, J. (1969). The California Child Q-Set. Berkeley, CA:
 Institute of Human Development, University of California.

 Pederson, D. R., Moran, G., & Bento, S. (1999). Maternal Behaviour Q-sort
 (version 3.1). London, ON: Psychology Department, Western University.

 Waters, E. (1995). Appendix A: The attachment Q-set (Version 3. 0).
 Monographs of the Society for Research in Child Development, 60, 234-246.
}
