% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qrcode_gen.R
\name{qrcode_gen}
\alias{qrcode_gen}
\title{QRcode generator}
\usage{
qrcode_gen(dataString, ErrorCorrectionLevel = "L", dataOutput = FALSE,
  plotQRcode = TRUE, wColor = "White", bColor = "black", mask = 1,
  softLimitFlag = TRUE)
}
\arguments{
\item{dataString}{input string for the QRcode}

\item{ErrorCorrectionLevel}{Error Correction Level. The available options are "L","M","Q" and " H". Default value as "L"}

\item{dataOutput}{option to export data as matrix. Default value is FALSE.}

\item{plotQRcode}{option to plot QRcode. Default value is TRUE.}

\item{wColor}{color of the white module(white squre) in QRcode. Default value "white".}

\item{bColor}{color pf the black module(black squre) in QRcode. Default value "black".}

\item{mask}{mask for QRcode to increase decodability. Available value is 0-7.}

\item{softLimitFlag}{flag to limit the QRcode version to 10. Default value TRUE.}
}
\value{
A matrix that represent the QRcode. 1 as black module and 0 as white module.
}
\description{
Create QRcode in R. Capable to generate all variant of QRcode, version 1 to 40 and Error correct level of "L","M","Q" and " H". Not all reader in market can support all QRcode version, \code{qrcode_gen} has a software limit to version 10 which is tested working in most reader.
}
\examples{
qrcode_gen('www.r-project.org')

 #User may change the color of the module
 qrcode_gen('www.r-project.org',bColor='Green3')
}

