% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qrCodeSpec.R
\docType{data}
\name{qrCodeSpec}
\alias{qrCodeSpec}
\title{QRcode specifications and requirements.}
\format{\preformatted{'data.frame':	160 obs. of  11 variables:
 $ Version       : int  1 1 1 1 2 2 2 2 3 3 ...
 $ ECL           : Factor w/ 4 levels "H","L","M","Q": 2 3 4 1 2 3 4 1 2 3 ...
 $ Numeric       : int  41 34 27 17 77 63 48 34 127 101 ...
 $ Alphanumeric  : int  25 20 16 10 47 38 29 20 77 61 ...
 $ Byte          : int  17 14 11 7 32 26 20 14 53 42 ...
 $ Dcword        : int  19 16 13 9 34 28 22 16 55 44 ...
 $ ECwordPerBlock: int  7 10 13 17 10 16 22 28 15 26 ...
 $ Grp1          : int  1 1 1 1 1 1 1 1 1 1 ...
 $ DCinGrp1      : int  19 16 13 9 34 28 22 16 55 44 ...
 $ Grp2          : int  0 0 0 0 0 0 0 0 0 0 ...
 $ DCinGrp2      : int  0 0 0 0 0 0 0 0 0 0 ...
}}
\usage{
data(qrCodeSpec)
}
\description{
List of different versions of QRcode specification and requirements.
 For more details can refer to QRcode standard.
}
\details{
\itemize{
   \item Version. QRcode version.
   \item ECL. Error Correction Level. Consisted of 4 level L,M,Q and H.
   \item Numeric. Number of numeric character supported by the given version and ECL.
   \item Alphanumeric. Number of alphabet and numeric character
     supported by the given version and ECL.
   \item Byte.Number of byte supported by the given version and ECL.
   \item Dcword. Data code word count.
   \item ECwordPerBlock. Error correction word count per block.
   \item Grp1. Number of block in group 1.
   \item DCinGrp1. Number of data code word in each group 1.
   \item Grp2. Number of block in group 2.
   \item DCinGrp2. Number of data code word in each group 2.
 }
}
\keyword{dataset}

